import { defineConfig } from "vite";
import react from "@vitejs/plugin-react";

export default defineConfig({
  plugins: [react()],
  server: {
    port: 5173,
    host: true,
    proxy: {
      "/api": {
        target: process.env.CHATAPP_API_PROXY_TARGET || "http://127.0.0.1:8080",
        changeOrigin: true,
        secure: false,
      },
    },
  },
});
