# Web App (React)

This folder contains the **test client** for the backend (Vite + React). It works on desktop and mobile browsers.

If you just want to run the app, you **don’t** need to start this Vite dev server: the backend serves the built web client at `/` on the backend port (default `8080`).

## Dev

```bash
cd web
npm install
npm run dev
```

By default, Vite proxies `/api/*` to `http://127.0.0.1:8080` (backend default).

- Change proxy target: `CHATAPP_API_PROXY_TARGET=http://127.0.0.1:8080 npm run dev`
- Or set the API base URL in the app Settings (or via `VITE_API_BASE` at build time).

### Mobile

`npm run dev` binds to `0.0.0.0` so you can open the app on your phone via:

`http://<your-pc-ip>:5173`
