# Unraid deployment

This repo builds a single Docker image that serves:

- Web chat client at `/`
- Admin UI at `/admin/`
- JSON API at `/api/v1/...`

## Build on Unraid

Open an Unraid terminal and run in the repo folder:

```bash
docker build -t chat-app:latest -f backend/Dockerfile .
```

If you use a private registry, tag the image accordingly (example): `192.168.188.10/chat-app:latest`

## Run (recommended)

Create persistent folders (adjust paths if you prefer):

```bash
mkdir -p /mnt/user/appdata/chat-app/data
mkdir -p /mnt/user/appdata/chat-app/backups
```

Run the container:

```bash
docker run -d \
  --name chat-app \
  --restart unless-stopped \
  --user 99:100 \
  -p 8080:8080 \
  -e CHATAPP_BIND=0.0.0.0 \
  -e CHATAPP_PORT=8080 \
  -e CHATAPP_DATA_DIR=/data \
  -e CHATAPP_DB_PATH=/data/app.db \
  -e CHATAPP_STORAGE_DIR=/data/storage \
  -e CHATAPP_BACKUPS_DIR=/backups \
  -v /mnt/user/appdata/chat-app/data:/data \
  -v /mnt/user/appdata/chat-app/backups:/backups \
  chat-app:latest
```

Open:

- Web app: `http://<your-unraid-ip>:8080/`
- Admin: `http://<your-unraid-ip>:8080/admin/`

If port `8080` is already used on your Unraid host, change the left side of `-p <host-port>:8080`.

## Private registry (optional)

If your registry is plain HTTP (like `http://192.168.188.10`), Docker must be configured to allow it as an insecure registry.

Example flow:

```bash
docker build -t 192.168.188.10/chat-app:latest -f backend/Dockerfile .
docker push 192.168.188.10/chat-app:latest
```

Then replace `chat-app:latest` in the run command with `192.168.188.10/chat-app:latest`.

## Create the first admin user

Open the admin UI and use **Bootstrap** to create the first admin account (only available until the first admin exists).

## TLS (optional)

Most Unraid setups terminate TLS in a reverse proxy (SWAG / NPM / Traefik). If you want the backend to do TLS itself:

- Mount your certs into the container, e.g. `-v /path/to/certs:/config/certs:ro`
- Set:
  - `CHATAPP_CERT_DIR=/config/certs`
  - `CHATAPP_CERT_FILE=fullchain.pem`
  - `CHATAPP_KEY_FILE=privkey.pem`
