# Private Friends Chat (MVP)

This repository implements the backend foundations described in `SPEC.md`, with a minimal self-hostable, Docker-ready Python backend (SQLite + local file storage).

## Quick start (local)

```bash
python3 -m backend.chatapp
```

By default it listens on `http://127.0.0.1:8080` and serves:

- Admin UI: `http://127.0.0.1:8080/admin/`
- Web chat: `http://127.0.0.1:8080/` (when a built web client is available; the Docker image includes it)

Note: Port `5173` is only for the optional Vite dev server in `web/` (frontend development). For “just run it”, use port `8080`.

## Quick start (Docker Compose)

```bash
docker compose up
```

Compose runs a prebuilt image (no `build:`). Set `CHATAPP_IMAGE` if needed, e.g.:

```bash
CHATAPP_IMAGE=192.168.188.10/chat-app:latest docker compose up
```

Open:

- Web chat: `http://localhost:8080/`
- Admin UI: `http://localhost:8080/admin/` (bootstrap the first admin account)

## Unraid

See `UNRAID.md` for a ready-to-run Unraid setup (serves the web client at `/`).

## Configuration

Environment variables (all optional):

- `CHATAPP_BIND` (default `127.0.0.1`)
- `CHATAPP_PORT` (default `8080`)
- `CHATAPP_WEB_ROOT` (optional; serves web UI from this folder if set)
- `CHATAPP_DATA_DIR` (default `./data`)
- `CHATAPP_DB_PATH` (default `./data/app.db`)
- `CHATAPP_STORAGE_DIR` (default `./data/storage`)
- `CHATAPP_CERT_DIR` (default empty; enables TLS if set)
- `CHATAPP_CERT_FILE` (default `fullchain.pem`)
- `CHATAPP_KEY_FILE` (default `privkey.pem`)
- `CHATAPP_CERT_RELOAD_SECONDS` (default `300`)

## Notes

- The backend exposes a JSON API under `/api/v1/...` and a simple built-in admin UI under `/admin/`.
- Push + bot integrations are scaffolded as stored configuration/queue entries; actual delivery workers can be added next.
